/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MKaisyaDao;
import jp.mosp.system.dto.MKaisyaDto;
import jp.mosp.system.vo.KaisyaMasterCardVo;

public class KaisyaMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_KAISYA_MASTER_CARD_SHOW   = "S2015";	// \(ǉ)
	private static final String CMD_KAISYA_MASTER_CARD_SELECT = "S2016";	// \(I)
	private static final String CMD_KAISYA_MASTER_CARD_INSERT = "S2017";	// o^
	private static final String CMD_KAISYA_MASTER_CARD_UPDATE = "S2018";	// XV
	private static final String CMD_KAISYA_MASTER_CARD_DELETE = "S2019";	// 폜

	/**
	 * RXgN^
	 */
	public KaisyaMasterCardAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		// VO̎擾		
		KaisyaMasterCardVo vo = new KaisyaMasterCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// DAȌ
		MKaisyaDao dao;
		dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// N\@v_EXg쐬
		vo.aryPltKikinKbn = getFundParticipationArray();
		// DTO̎擾		
		MKaisyaDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MKaisyaDto ? (MKaisyaDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_KAISYA_MASTER_CARD_SHOW)) {
			vo.setDefaultValues();
			vo.setMode(KaisyaMasterCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			setMode(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_DELETE)) {
			// 폜
			delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MKaisyaDto insert(KaisyaMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtJCode()), vo);
		// DTȌ
		MKaisyaDto dto = new MKaisyaDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getId());
		chkInsert(dto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MKaisyaDto update(KaisyaMasterCardVo vo, MKaisyaDto dto) throws Exception {
		vo.setMode(KaisyaMasterCardVo.MODE_UPDATE);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtJCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MKaisyaDto retDto = dao.findForKey(dto.getId());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void delete(KaisyaMasterCardVo vo, MKaisyaDto dto) throws Exception {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(KaisyaMasterCardVo vo) throws Exception {
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(KaisyaMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(KaisyaMasterCardVo.MODE_UPDATE);
		}
	}

	/**
	 * ېőΏۋ敪擾
	 * @return ېőΏۋ敪z
	 */
	private String[][] getFundParticipationArray() {
		// z̍쐬
		String[][] aryPosition = new String[2][2];
		for (int i = 0; i < aryPosition.length; i++) {
			if (i == 0) {
				aryPosition[i][0] = String.valueOf(i);
				aryPosition[i][1] = CommonConst.NAM_FUND_NOT_PARTICIPATION;
			} else {
				aryPosition[i][0] =  String.valueOf(i);
				aryPosition[i][1] = CommonConst.NAM_FUND_PARTICIPATION;
			}
		}
		return aryPosition;
	}

}
